<?php
require_once 'vendor/autoload.php';
require_once 'src/config/database.php';
require_once 'src/controllers/AuthController.php';

session_start();

$client = new Google_Client();
$client->setClientId('YOUR_CLIENT_ID');
$client->setClientSecret('YOUR_CLIENT_SECRET');
$client->setRedirectUri('http://yourdomain.com/php-google-sso/src/google-callback.php');
$client->addScope('email');
$client->addScope('profile');

if (isset($_GET['code'])) {
    $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);
    $client->setAccessToken($token['access_token']);

    $oauth2 = new Google_Service_Oauth2($client);
    $userInfo = $oauth2->userinfo->get();

    $authController = new AuthController();
    $authController->handleGoogleCallback($userInfo);
} else {
    header('Location: login.php');
    exit();
}
?>